Function _consOutput:Int(ls:Byte Ptr)
	Local cons:TChaosConsole = TChaosConsole.getPerLuaState(ls)
	If cons = Null Return 0

	Local str:String = luaL_checkstring(ls, 1)
	cons.output(str)
	Return 0
End Function
'---------------------------------------------------------------------------------------------------------------------------------

Function _consGet:Int(ls:Byte Ptr)
	Local cons:TChaosConsole = TChaosConsole.getPerLuaState(ls)
	If cons = Null Return 0

	Local objName:String = luaL_checkstring(ls, 1)
	Local fldName:String = luaL_checkstring(ls, 2)
	
	Local arrPos:Int = fldName.find("[")
	If arrPos > -1
		arrPos = Int(fldName[fldName.find("[")+1..fldName.find("]")])
		fldName = fldName[..fldName.Find("[")]
	End If
	
	Local val:String

	Try
		val = cons._objWrapper.get(objName, fldName, arrPos)
	Catch ex:Object
		cons.output("Error getting field value: " + ex.ToString() )
		Return 0
	End Try

	lua_pushstring(ls, val)
	Return 1

End Function
'---------------------------------------------------------------------------------------------------------------------------------

Function _consSet:Int(ls:Byte Ptr)
	Local cons:TChaosConsole = TChaosConsole.getPerLuaState(ls)
	If cons = Null Return 0

	Local objName:String = luaL_checkstring(ls, 1)
	Local fldName:String = luaL_checkstring(ls, 2)
	Local val:String = ""

	Select lua_type(ls, 1)
		Case LUA_TNUMBER val = String(luaL_checknumber(ls, 3) )
		Case LUA_TSTRING val = luaL_checkstring(ls, 3)
	End Select
	
	Local arrPos:Int = fldName.find("[")
	If arrPos > -1
		arrPos = Int(fldName[fldName.find("[")+1..fldName.find("]")])
		fldName = fldName[..fldName.Find("[")]
	End If
	
	Try
		cons._objWrapper.set(objName, fldName, val, arrPos)
	Catch ex:Object
		cons.output("Error setting field value: " + ex.ToString() )
		Return 0
	End Try

	Return 0

End Function
'---------------------------------------------------------------------------------------------------------------------------------

Function _consDump:Int(ls:Byte Ptr)
	Local cons:TChaosConsole = TChaosConsole.getPerLuaState(ls)
	If cons = Null Return 0

	Local name:String = luaL_checkstring(ls, 1)
	Local dumpMap:TMap

	Try
		dumpMap = cons._objWrapper.dump(name)
	Catch ex:Object
		cons.output("Error dumping object: " + ex.ToString())
		Return 0
	End Try

	cons.output("Object " + name + ":" + cons._objWrapper.Name(name))
	For Local key:String = EachIn dumpMap.Keys()
		cons.output("   " + key + " = " + String(dumpMap.ValueForKey(key)))
	Next

	Return 0

End Function
'---------------------------------------------------------------------------------------------------------------------------------

Function _consCreate:Int(ls:Byte Ptr)
	Local cons:TChaosConsole = TChaosConsole.getPerLuaState(ls)
	If cons = Null Return 0

	Local objName:String = luaL_checkstring(ls, 1)
	Local insName:String = luaL_checkstring(ls, 2)

	Local id:TTypeId = TTypeId.ForName(objName)
	If id = Null
		cons.output("No such object '" + objName + "'")
		Return 0
	End If
				
	cons._objWrapper.register(insName, id.NewObject())
	cons.output("Created new object from type '" + objName + "'")
	Return 0
End Function
'---------------------------------------------------------------------------------------------------------------------------------

Function _consDelete:Int(ls:Byte Ptr)
	Local cons:TChaosConsole = TChaosConsole.getPerLuaState(ls)
	If cons = Null Return 0

	Local insName:String = luaL_checkstring(ls, 1)

	Try
		cons._objWrapper.unregister(insName)
	Catch ex:Object
		cons.output("Error deleting object: " + ex.ToString())
		Return False
	End Try
	
	cons.output("Object '" + insName + "' deleted")
	Return 0
End Function
'---------------------------------------------------------------------------------------------------------------------------------

Function _consList:Int(ls:Byte Ptr)
	Local cons:TChaosConsole = TChaosConsole.getPerLuaState(ls)
	If cons = Null Return 0

	cons.output("Registered objects: ")
	For Local obj:String = EachIn cons._objWrapper.list()
		cons.output("- " + obj)
	Next
	
	cons.output("Registered functions: ")
	For Local func:String = EachIn cons._funcMap.Keys()
		cons.output("- " + func)
	Next
	Return 0
End Function
'---------------------------------------------------------------------------------------------------------------------------------

Function _consSave:Int(ls:Byte Ptr)
	Local cons:TChaosConsole = TChaosConsole.getPerLuaState(ls)
	If cons = Null Return 0

	Local file:String = luaL_checkstring(ls, 1)

	Local stream:TStream = WriteFile(file)
	For Local i:Int = 0 Until cons._lineBuffer.length
		stream.WriteLine cons._lineBuffer[i]
	Next
	stream.Close()

End Function
'---------------------------------------------------------------------------------------------------------------------------------

Function _consClear:Int(ls:Byte Ptr)
	Local cons:TChaosConsole = TChaosConsole.getPerLuaState(ls)
	If cons = Null Return 0

	cons.Clear()

End Function
'---------------------------------------------------------------------------------------------------------------------------------

Function _consObjToTable:Int(ls:Byte Ptr)
	Local cons:TChaosConsole = TChaosConsole.getPerLuaState(ls)
	If cons = Null Return 0

	Local objName:String = luaL_checkstring(ls, 1)
	Local tabName:String = luaL_checkstring(ls, 2)
	Local dumpMap:TMap

	Try
		dumpMap = cons._objWrapper.dump(objName)
	Catch ex:Object
		cons.output("Error dumping object: " + ex.ToString())
		Return 0
	End Try

	lua_newtable(ls)

	For Local key:String = EachIn dumpMap.Keys()
		lua_pushstring(ls, String(dumpMap.ValueForKey(key) ) )
		lua_setfield(ls, -2, key.split(":")[0])
	Next

	lua_setglobal(ls, tabName)

End Function
'---------------------------------------------------------------------------------------------------------------------------------