Type TObjectWrapper

	Field _objMap:TMap
	
	Method New()
		_objMap = New TMap
	End Method
	'---------------------------------------------------------------------------------------------------------------------------------
	
	Method register(name:String, obj:Object)
		_objMap.insert(name, obj)
	End Method
	'---------------------------------------------------------------------------------------------------------------------------------
	
	Method unregister(name:String)
		If Not _objMap.Contains(name) Throw "No such object '" + name + "'"
		_objMap.remove(name)
	End Method
	'---------------------------------------------------------------------------------------------------------------------------------
	
	Method set:Int(objName:String, fldName:String, val:String, index:Int = -1)
		If Not _objMap.Contains(objName)
			Throw "No such object '" + objName + "'"
		End If
		
		Local obj:Object = _objMap.ValueForKey(objName)
		Local id:TTypeId = TTypeId.ForObject(obj)
		Local fld:TField = id.FindField(fldName)
		
		If fld = Null Throw "No such field '" + fldName + "'"
		
		If fld.TypeId().SuperType() = ArrayTypeId
			Local arrId:TTypeId = fld.TypeId()
			If index < 0 Or index >= fld.TypeId().ArrayLength(fld.Get(obj)) Throw "Array index out of bounds '" + fldName + "[" + index + "]'"
			arrId.SetArrayElement(fld.Get(obj), index, val)
			Return 0
		End If
		
		Select fld.TypeId()
			Case IntTypeId, ByteTypeId fld.SetInt(obj, Int(val))
			Case StringTypeId fld.SetString(obj, val)
			Case FloatTypeId fld.SetFloat(obj, Float(val))				
		End Select
		
	End Method
	'---------------------------------------------------------------------------------------------------------------------------------
	
	Method get:String(objName:String, fldName:String, index:Int = -1)
		If Not _objMap.Contains(objName)
			Throw "No such object '" + objName + "'"
		End If
		
		Local obj:Object = _objMap.ValueForKey(objName)
		Local id:TTypeId = TTypeId.ForObject(obj)
		Local fld:TField = id.FindField(fldName)
		
		If fld = Null Throw "No such field '" + fldName + "'"
		
		If fld.TypeId().SuperType() = ArrayTypeId
			Local arrId:TTypeId = fld.TypeId()
			If index >= fld.TypeId().ArrayLength(fld.Get(obj)) Throw "Array index out of bounds '" + fldName + "[" + index + "]'"
			
			If index = -1
				Local valStr:String = ""
				For Local i:Int = 0 Until fld.TypeId().ArrayLength(fld.Get(obj))
					valStr:+String(fld.TypeId().GetArrayElement(fld.Get(obj), i))+","
				Next
				valStr = "["+valStr[..valStr.length-1]+"]"
				Return valStr
			End If
			
			Return String(arrId.GetArrayElement(fld.Get(obj), index))
		End If
		
		Select fld.TypeId()
			Case IntTypeId, ByteTypeId Return fld.GetInt(obj)
			Case StringTypeId Return fld.GetString(obj)
			Case FloatTypeId Return fld.GetFloat(obj)				
		End Select
		
	End Method
	'---------------------------------------------------------------------------------------------------------------------------------
	
	Method call:String(objName:String, mthName:String, args:Object[])
		If Not _objMap.Contains(objName)
			Throw "No such object '" + objName + "'"
		End If
		
		Local obj:Object = _objMap.ValueForKey(objName)
		Local id:TTypeId = TTypeId.ForObject(obj)
		Local mth:TMethod = id.findMethod(mthName)
		
		If mth = Null Return -1
		
		If args.length <> mth._argTypes.length
			Throw "Not enough arguments, " + mth._argTypes.length + " expected (" + args.length + " given)"
		End If
		
		Return String(mth.Invoke(obj, args))
		
	End Method
	'---------------------------------------------------------------------------------------------------------------------------------

	Method dump:TMap(objName:String)
		If Not _objMap.Contains(objName)
			Throw "No such object '" + objName + "'"
		End If
		
		Local obj:Object = _objMap.ValueForKey(objName)
		Local id:TTypeId = TTypeId.ForObject(obj)
		
		Local dumpMap:TMap = New TMap
		
		For Local fld:TField=EachIn id.EnumFields()
			Local valStr:String = String(fld.Get(obj))

			If fld.TypeId().SuperType() = ArrayTypeId
				valStr = ""
				For Local i:Int = 0 Until fld.TypeId().ArrayLength(fld.Get(obj))
					valStr:+String(fld.TypeId().GetArrayElement(fld.Get(obj), i))+","
				Next
				valStr = "["+valStr[..valStr.length-1]+"]"
			End If
			
			dumpMap.Insert(fld.Name()+":"+String(fld.TypeId()._name), valStr)
		Next
		
		Return dumpMap
	End Method
	'---------------------------------------------------------------------------------------------------------------------------------
	
	Method name:String(objName:String)
		If Not _objMap.Contains(objName)
			Throw "No such object '" + objName + "'"
		End If
		
		Local obj:Object = _objMap.ValueForKey(objName)
		Local id:TTypeId = TTypeId.ForObject(obj)
		
		Return id.Name()
	End Method
	'---------------------------------------------------------------------------------------------------------------------------------

	Method list:TList()
		Local tmpList:TList = New TList
		For Local key:String = EachIn _objMap.Keys()
			tmpList.AddLast(key + ":" + name(key))
		Next
		Return tmpList
	End Method
	'---------------------------------------------------------------------------------------------------------------------------------
End Type

Type TFunctionWrapper

	Field _name:String
	Field _func:Int(ls:Byte Ptr)
	Field _argCount:Int
	
	Function Create:TFunctionWrapper(name:String, argCount:Int, func:Int(ls:Byte Ptr))
		Local tmpFunc:TFunctionWrapper = New TFunctionWrapper
		tmpFunc._name = name
		tmpFunc._func = func
		tmpFunc._argCount = argCount
		Return tmpFunc
	End Function
	'---------------------------------------------------------------------------------------------------------------------------------

End Type
'---------------------------------------------------------------------------------------------------------------------------------